//
//  Chap2.h
//  Sinc
//
//  Created by Y m on 2018/04/01.
//  Copyright  2018N Y m. All rights reserved.
//

#ifndef Chap2_h
#define Chap2_h
/*------------------------------------------------*/
/*mQn֐ϊ@@@@@@@@@@@@@@@@@@@@@ @*/
/*------------------------------------------------*/
//@ɂ鐶֐̋t֐
double SecantHayter(double (*f)(double,int,int),int k,int m,double al){
    /*Hayter^z֐f(doube,int,int)̕f(x,k,m)=1-alxɂĉ@*/
    int cnt,i;
    double t0=0,t1,t2,f0=0,f1,f2,dt,df;
    /*1̋[t0,t1]ɉ͂*/
    t1=0;f1=f(t1,k,m)-1+al;
    while(f1<0){
        t0=t1;f0=f1;
        t1+=1;f1=f(t1,k,m)-1+al;
    }
    /*1/64̋[t0,t1]ɉ͂:񕪖@*/
    for(i=1;i<=6;i++){
        t2=(t0+t1)/2;f2=f(t2,k,m)-1+al;
        if(f2<0){t0=t2;f0=f2;} else {t1=t2;f1=f2;}
    }
    /*@Őxグ*/
    t1=t0;f1=f0;
    t0=t1-0.001;f0=f(t0,k,m)-1+al;
    dt=t1-t0;
    df=f1-f0;
    cnt=2;
    while(fabs(f1)>1.0e-12 && fabs(df)>1.0e-12 && cnt<1000){
        dt=-f1*dt/df;
        t0=t1;f0=f1;
        t1=t1+dt;
        f1=f(t1,k,m)-1+al;
        df=f1-f0;
        cnt++;
    }
    if(fabs(df)>1.0e-14)t1=t1-f1*dt/df;/*final modification*/
    return t1;
};
double SecantDunnettB(double (*f)(double,int,double*),int k,double *lms,double al){
    /*Dunnett B^z֐f(double,int,double*)̕f(x,k,lms)=1-alxɂĉ@*/
    int cnt,i;
    double t0=0,t1,t2,f0=0,f1,f2,dt,df;
    /*1̋[t0,t1]ɉ͂*/
    t1=0;f1=f(t1,k,lms)-1+al;
    while(f1<0){
        t0=t1;f0=f1;
        t1+=1;f1=f(t1,k,lms)-1+al;
    }
    /*1/64̋[t0,t1]ɉ͂:񕪖@*/
    for(i=1;i<=6;i++){
        t2=(t0+t1)/2;f2=f(t2,k,lms)-1+al;
        if(f2<0){t0=t2;f0=f2;} else {t1=t2;f1=f2;}
    }
    /*@Őxグ*/
    t1=t0;f1=f0;
    t0=t1-0.001;f0=f(t0,k,lms)-1+al;
    dt=t1-t0;
    df=f1-f0;
    cnt=2;
    while(fabs(f1)>1.0e-12 && fabs(df)>1.0e-12 && cnt<1000){
        dt=-f1*dt/df;
        t0=t1;f0=f1;
        t1=t1+dt;
        f1=f(t1,k,lms)-1+al;
        df=f1-f0;
        cnt++;
    }
    if(fabs(df)>1.0e-14)t1=t1-f1*dt/df;/*final modification*/
    return t1;
};
double SecantDunnettTB(double (*f)(double,int,int*),int k,int *ns,double al){
    /*Dunnett TBz֐f(double,int,int*)̕f(x,k,ns)=1-alxɂĉ@*/
    int cnt,i;
    double t0=0,t1,t2,f0=0,f1,f2,dt,df;
    /*1̋[t0,t1]ɉ͂*/
    t1=0;f1=f(t1,k,ns)-1+al;
    while(f1<0){
        t0=t1;f0=f1;
        t1+=1;f1=f(t1,k,ns)-1+al;
    }
    /*1/64̋[t0,t1]ɉ͂:񕪖@*/
    for(i=1;i<=6;i++){
        t2=(t0+t1)/2;f2=f(t2,k,ns)-1+al;
        if(f2<0){t0=t2;f0=f2;} else {t1=t2;f1=f2;}
    }
    /*@Őxグ*/
    t1=t0;f1=f0;
    t0=t1-0.001;f0=f(t0,k,ns)-1+al;
    dt=t1-t0;
    df=f1-f0;
    cnt=2;
    while(fabs(f1)>1.0e-12 && fabs(df)>1.0e-12 && cnt<1000){
        dt=-f1*dt/df;
        t0=t1;f0=f1;
        t1=t1+dt;
        f1=f(t1,k,ns)-1+al;
        df=f1-f0;
        cnt++;
    }
    if(fabs(df)>1.0e-14)t1=t1-f1*dt/df;/*final modification*/
    return t1;
};
double Secantt(double (*f)(double,int),int k,double al){
    /*tz^z֐f(double,int)̕f(x,k)=1-alxɂĉ@*/
    int cnt,i;
    double t0=0,t1,t2,f0=0,f1,f2,dt,df;
    /*1̋[t0,t1]ɉ͂*/
    t1=0;f1=f(t1,k)-1+al;
    while(f1<0){
        t0=t1;f0=f1;
        t1+=1;f1=f(t1,k)-1+al;
    }
    /*1/64̋[t0,t1]ɉ͂:񕪖@*/
    for(i=1;i<=6;i++){
        t2=(t0+t1)/2;f2=f(t2,k)-1+al;
        if(f2<0){t0=t2;f0=f2;} else {t1=t2;f1=f2;}
    }
    /*@Őxグ*/
    t1=t0;f1=f0;
    t0=t1-0.001;f0=f(t0,k)-1+al;
    dt=t1-t0;
    df=f1-f0;
    cnt=2;
    while(fabs(f1)>1.0e-12 && fabs(df)>1.0e-12 && cnt<1000){
        dt=-f1*dt/df;
        t0=t1;f0=f1;
        t1=t1+dt;
        f1=f(t1,k)-1+al;
        df=f1-f0;
        cnt++;
    }
    if(fabs(df)>1.0e-14)t1=t1-f1*dt/df;/*final modification*/
    return t1;
};
double SecantNormalB(double (*f)(double,int,double*,int),int k,double *lms,int m,double al){
    /*Normal B^z֐f(t,int,double*,int)̕f(x,k)=1-alxɂĉ@*/
    int cnt,i;
    double t0=0,t1,t2,f0=0,f1,f2,dt,df;
    /*1̋[t0,t1]ɉ͂*/
    t1=0;f1=f(t1,k,lms,m)-1+al;
    while(f1<0){
        t0=t1;f0=f1;
        t1+=1;f1=f(t1,k,lms,m)-1+al;
    }
    /*1/64̋[t0,t1]ɉ͂:񕪖@*/
    for(i=1;i<=6;i++){
        t2=(t0+t1)/2;f2=f(t2,k,lms,m)-1+al;
        if(f2<0){t0=t2;f0=f2;} else {t1=t2;f1=f2;}
    }
    /*@Őxグ*/
    t1=t0;f1=f0;
    t0=t1-0.001;f0=f(t0,k,lms,m)-1+al;
    dt=t1-t0;
    df=f1-f0;
    cnt=2;
    while(fabs(f1)>1.0e-12 && fabs(df)>1.0e-12 && cnt<1000){
        dt=-f1*dt/df;
        t0=t1;f0=f1;
        t1=t1+dt;
        f1=f(t1,k,lms,m)-1+al;
        df=f1-f0;
        cnt++;
    }
    if(fabs(df)>1.0e-14)t1=t1-f1*dt/df;/*final modification*/
    return t1;
};
double SecantNormalC(double (*f)(double,int,double*),int k,double *lms,double al){
    /*Normal C^z֐f(t,int,double*)̕f(x,k)=1-alxɂĉ@*/
    int cnt,i;
    double t0=0,t1,t2,f0=0,f1,f2,dt,df;
    /*1̋[t0,t1]ɉ͂*/
    t1=0;f1=f(t1,k,lms)-1+al;
    cnt=0;
    while(f1<0){
        t0=t1;f0=f1;
        t1+=1;f1=f(t1,k,lms)-1+al;
        cnt++;
    }
    /*1/64̋[t0,t1]ɉ͂:񕪖@*/
    for(i=1;i<=6;i++){
        t2=(t0+t1)/2;f2=f(t2,k,lms)-1+al;
        if(f2<0){t0=t2;f0=f2;} else {t1=t2;f1=f2;}
    }
    /*@Őxグ*/
    t1=t0;f1=f0;
    t0=t1-0.001;f0=f(t0,k,lms)-1+al;
    dt=t1-t0;
    df=f1-f0;
    cnt=2;
    while(fabs(f1)>1.0e-12 && fabs(df)>1.0e-12 && cnt<1000){
        dt=-f1*dt/df;
        t0=t1;f0=f1;
        t1=t1+dt;
        f1=f(t1,k,lms)-1+al;
        df=f1-f0;
        cnt++;
    }
    if(fabs(df)>1.0e-14)t1=t1-f1*dt/df;/*final modification*/
    return t1;
};

//z֐f(t)F(t)=\int_0^ f(st)g(s|m)ds ւ̐ϕϊ(DEϕ)
double psm1(double x){/* = (x)-1F(x)DEϊ֐*/
    return expm1(x - expm1(-x));
};
double ps1(double x){/* = '(x)FDEϊ֐(x)̓֐*/
    return (1+exp(-x))*exp(x - expm1(-x));
};
double chiHayterFun(double x,double (*f)(double,int),double t,int k,int m){
    /*Hayter^z֐f(doube,int,int)ɑ΂ϕ֐*/
    double sm;
    sm = sqrt((double) m);
    return f(t*(1+psm1(x/sm)),k)*g1PDF(psm1(x/sm),m)*ps1(x/sm)/sm;
};
double chiIntegralHayter(double (*f)(double,int),double t,int k,int m){
    /*Hayter^z֐f(doube,int,int)ɑ΂ϕϊ(DEϕ)*/
    double S,h,eps,term;
    int i;
    /*`*/
    h = 0.1;
    eps = 1.0e-16;
    S = chiHayterFun(0,f,t,k,m);
    i = 1; term = 1;
    while(fabs(term) > eps){
        term = chiHayterFun(i*h,f,t,k,m);
        S += term;
        i++;
    };
    i = 1; term = 1;
    while(fabs(term) > eps){
        term = chiHayterFun(-i*h,f,t,k,m);
        S += term;
        i++;
    };
    return(h*S);
};
double chiDunnettFun(double x,double (*f)(double,int,double*),double t,int k,double *lms,int m){
    /*Dunnett^z֐f(doube,int,double*)ɑ΂ϕϊ(DEϕ)*/
    double sm;
    sm = sqrt((double) m);
    return f(t*(1+psm1(x/sm)),k,lms)*g1PDF(psm1(x/sm),m)*ps1(x/sm)/sm;
};
double chiIntegralDunnett(double (*f)(double,int,double*),double t,int k,double *lms,int m){
    /*Dunnet^֐D(x,k,lms)TD(x,k,ns)𐶐ϕϊ(DEϕ),m=Sum(ns[i],{i,0,k-1})*/
    double S,h,eps,term;
    int i;
    /*`*/
    h = 0.1;
    eps = 1.0e-16;
    S = chiDunnettFun(0,f,t,k,lms,m);
    i = 1; term = 1;
    while(fabs(term) > eps){
        term = chiDunnettFun(i*h,f,t,k,lms,m);
        S += term;
        i++;
    };
    i = 1; term = 1;
    while(fabs(term) > eps){
        term = chiDunnettFun(-i*h,f,t,k,lms,m);;
        S += term;
        i++;
    };
    return(h*S);
};
#endif /* Chap2_h */
